<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class ChangePasswordRequest extends FormRequest
{
  /**
   * Determine if the user is authorized to make this request.
   */
  public function authorize(): bool
  {
    return true;
  }

  /**
   * Get the validation rules that apply to the request.
   *
   * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
   */
  public function rules(): array
  {
    return [
      'new_password' => 'required|string|min:8|confirmed',
    ];
  }

  /**
   * Get custom messages for validator errors.
   *
   * @return array
   */
  public function messages(): array
  {
    return [
      'current_password.required' => 'كلمة المرور الحالية مطلوبة',
      'new_password.required' => 'كلمة المرور الجديدة مطلوبة',
      'new_password.min' => 'يجب أن لا تقل كلمة المرور عن 8 أحرف',
      'new_password.confirmed' => 'تأكيد كلمة المرور غير متطابق',
    ];
  }
}
