<x-guest-layout>
    <x-slot name="headerTitle">تسجيل الدخول</x-slot>

    <!-- Logo -->
    <div class="auth-logo-area">
        @php
        $drawerLogo = \App\Models\Setting::get('logo_path');
        @endphp
        @if($drawerLogo)
        <img src="{{ asset('storage/' . $drawerLogo) }}" alt="Tijan Logo"
            style="width: 60px; height: 68px; object-fit: contain;" />
        @else
        <x-tijan-logo width="72" height="80" />
        @endif
        <span class="auth-brand-name">Tijan</span>
    </div>

    <div class="auth-body">
        <h1 class="auth-title">تسجيل الدخول</h1>

        <!-- Session Status -->
        @if (session('status'))
            <div class="session-status">{{ session('status') }}</div>
        @endif

        <form method="POST" action="{{ route('login') }}">
            @csrf

            <!-- Email -->
            <div class="form-group">
                <label class="form-label" for="email">بريدك الإلكتروني</label>
                <input id="email" type="email" name="email" value="{{ old('email') }}"
                    placeholder="أدخل بريدك الإلكتروني" class="form-input {{ $errors->has('email') ? 'error' : '' }}"
                    required autofocus autocomplete="username">
                @error('email')
                    <p class="form-error">{{ $message }}</p>
                @enderror
            </div>

            <!-- Password -->
            <div class="form-group">
                <label class="form-label" for="password">كلمة السر</label>
                <input id="password" type="password" name="password" placeholder="أدخل كلمة المرور"
                    class="form-input {{ $errors->has('password') ? 'error' : '' }}" required
                    autocomplete="current-password">
                @error('password')
                    <p class="form-error">{{ $message }}</p>
                @enderror
            </div>

            <!-- Remember Me + Forgot -->
            <div style="display:flex; align-items:center; justify-content:space-between; margin-bottom:24px;">
                <div class="form-check-row" style="margin-bottom:0;">
                    <input id="remember_me" type="checkbox" name="remember">
                    <label for="remember_me">تذكرني</label>
                </div>
                @if (Route::has('password.request'))
                    <a href="{{ route('password.request') }}" class="forgot-link" style="margin-bottom:0;">
                        هل نسيت كلمة السر؟
                    </a>
                @endif
            </div>

            <!-- Submit -->
            <button type="submit" class="btn-primary" id="login-btn">
                دخول
            </button>
        </form>
    </div>
</x-guest-layout>