<x-guest-layout>
    <x-slot name="headerTitle">إعادة تعيين كلمة المرور</x-slot>

    <!-- Logo -->
    <div class="auth-logo-area" style="padding-bottom: 8px;">
        @php
        $drawerLogo = \App\Models\Setting::get('logo_path');
        @endphp
        @if($drawerLogo)
        <img src="{{ asset('storage/' . $drawerLogo) }}" alt="Tijan Logo"
            style="width: 60px; height: 68px; object-fit: contain;" />
        @else
        <x-tijan-logo width="60" height="68" />
        @endif
    </div>

    <div class="auth-body">
        <h1 class="auth-title">إعادة تعيين كلمة المرور</h1>

        <p class="auth-subtitle">
            أدخل كلمة المرور الجديدة وتأكيدها لإتمام عملية إعادة التعيين
        </p>

        <form method="POST" action="{{ route('password.store') }}">
            @csrf

            <!-- Password Reset Token -->
            <input type="hidden" name="token" value="{{ $request->route('token') }}">

            <!-- Email -->
            <div class="form-group">
                <label class="form-label" for="email">بريدك الإلكتروني</label>
                <input id="email" type="email" name="email" value="{{ old('email', $request->email) }}"
                    placeholder="أدخل بريدك الإلكتروني" class="form-input {{ $errors->has('email') ? 'error' : '' }}"
                    required autofocus autocomplete="username">
                @error('email')
                    <p class="form-error">{{ $message }}</p>
                @enderror
            </div>

            <!-- New Password -->
            <div class="form-group">
                <label class="form-label" for="password">كلمة المرور الجديدة</label>
                <input id="password" type="password" name="password" placeholder="أدخل كلمة المرور الجديدة"
                    class="form-input {{ $errors->has('password') ? 'error' : '' }}" required
                    autocomplete="new-password">
                @error('password')
                    <p class="form-error">{{ $message }}</p>
                @enderror
            </div>

            <!-- Confirm Password -->
            <div class="form-group">
                <label class="form-label" for="password_confirmation">تأكيد كلمة المرور</label>
                <input id="password_confirmation" type="password" name="password_confirmation"
                    placeholder="أعد إدخال كلمة المرور"
                    class="form-input {{ $errors->has('password_confirmation') ? 'error' : '' }}" required
                    autocomplete="new-password">
                @error('password_confirmation')
                    <p class="form-error">{{ $message }}</p>
                @enderror
            </div>

            <button type="submit" class="btn-primary" id="reset-password-btn" style="margin-top: 8px;">
                تعيين كلمة المرور
            </button>
        </form>
    </div>
</x-guest-layout>