<!DOCTYPE html>
<html lang="ar" dir="rtl">

<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <meta name="csrf-token" content="{{ csrf_token() }}">

  <title>{{ config('app.name', 'Tijan') }} - {{ $title ?? 'لوحة التحكم' }}</title>

  <!-- Fonts -->
  <link rel="preconnect" href="https://fonts.googleapis.com">
  <link href="https://fonts.googleapis.com/css2?family=Cairo:wght@300;400;500;600;700;800&display=swap"
    rel="stylesheet">

  <style>
    *,
    *::before,
    *::after {
      box-sizing: border-box;
      margin: 0;
      padding: 0;
      font-family: 'Cairo', sans-serif;

    }

    :root {
      --green-dark: #1A3C2E;
      --green-mid: #1F4D38;
      --green-btn: #1B4332;
      --green-hover: #163829;
      --green-light: #E8F0EC;
      --gold: #C9A84C;
      --text-dark: #1A1A1A;
      --text-mid: #4A4A4A;
      --text-light: #7A7A7A;
      --border: #D8D8D8;
      --bg: #F5F5F5;
      --white: #FFFFFF;
      --error: #C70202;
      --radius: 12px;
      --shadow: 0 4px 24px rgba(0, 0, 0, 0.10);
    }

    html,
    body {
      min-height: 100%;
      font-family: 'Cairo', sans-serif;
      background: var(--bg);
      color: var(--text-dark);
      direction: rtl;
    }

    /* ── Page wrapper ── */
    .admin-wrapper {
      min-height: 100vh;
      display: flex;
      align-items: flex-start;
      justify-content: center;
      background: var(--bg);
    }

    .admin-card {
      width: 100%;
      background: var(--white);
      min-height: 100vh;
      box-shadow: var(--shadow);
    }

    /* ── Top bar ── */
    .admin-topbar {
      background: var(--green-dark);
      color: var(--white);
      display: flex;
      align-items: center;
      justify-content: space-between;
      padding: 10px 16px;
      font-size: 13px;
      font-weight: 500;
    }

    .admin-topbar-title {
      font-size: 13px;
      font-weight: 500;
      letter-spacing: 0.3px;
    }

    .admin-topbar-menu {
      background: none;
      border: none;
      color: var(--white);
      cursor: pointer;
      display: flex;
      align-items: center;
      justify-content: center;
      padding: 4px;
      transition: opacity 0.2s;
    }

    .admin-topbar-menu:hover {
      opacity: 0.8;
    }

    /* ── Page heading ── */
    .admin-page-heading {
      display: flex;
      align-items: center;
      gap: 8px;
      padding: 14px 16px 10px;
      border-bottom: 1px solid var(--border);
    }

    .admin-page-heading .back-btn {
      background: none;
      border: none;
      font-size: 40px;
      font-weight: 700;
      color: var(--text-mid);
      cursor: pointer;
      text-decoration: none;
      line-height: 1;
    }

    .admin-page-heading h1 {
      font-size: 17px;
      font-weight: 700;
      color: var(--text-dark);
    }


    /* ── Content area ── */
    .admin-content {
      padding: 16px;
    }

    /* ── Flash messages ── */
    .flash-success {
      background: #E8F5E9;
      border: 1px solid #A5D6A7;
      color: #2E7D32;
      padding: 10px 14px;
      border-radius: 8px;
      font-size: 13px;
      margin-bottom: 14px;
      text-align: right;
    }

    .flash-error {
      background: #FFEBEE;
      border: 1px solid #EF9A9A;
      color: #C62828;
      padding: 10px 14px;
      border-radius: 8px;
      font-size: 13px;
      margin-bottom: 14px;
      text-align: right;
    }

    /* ── Buttons ── */
    .btn-primary {
      display: inline-flex;
      align-items: center;
      justify-content: center;
      gap: 6px;
      padding: 12px 20px;
      background: var(--green-btn);
      color: var(--white);
      border: none;
      border-radius: 8px;
      font-family: 'Cairo', sans-serif;
      font-size: 15px;
      font-weight: 700;
      cursor: pointer;
      transition: background 0.2s, transform 0.1s;
      text-decoration: none;
    }

    .btn-primary:hover {
      background: var(--green-hover);
    }

    .btn-primary:active {
      transform: scale(0.98);
    }

    .btn-primary.full {
      width: 100%;
    }

    .btn-danger {
      display: inline-flex;
      align-items: center;
      justify-content: center;
      gap: 5px;
      padding: 6px 12px;
      background: #FFF0F0;
      color: var(--error);
      border: 1px solid #FFCDD2;
      border-radius: 6px;
      font-family: 'Cairo', sans-serif;
      font-size: 13px;
      font-weight: 600;
      cursor: pointer;
      transition: background 0.2s;
      text-decoration: none;
    }

    .btn-danger:hover {
      background: #FFCDD2;
    }

    .btn-edit {
      display: inline-flex;
      align-items: center;
      justify-content: center;
      gap: 5px;
      padding: 6px 12px;
      background: #F0F4FF;
      color: #2563EB;
      border: 1px solid #BFDBFE;
      border-radius: 6px;
      font-family: 'Cairo', sans-serif;
      font-size: 13px;
      font-weight: 600;
      cursor: pointer;
      transition: background 0.2s;
      text-decoration: none;
    }

    .btn-edit:hover {
      background: #DBEAFE;
    }

    .btn-cancel {
      display: inline-flex;
      align-items: center;
      justify-content: center;
      padding: 12px 20px;
      background: var(--white);
      color: var(--text-mid);
      border: 1.5px solid var(--border);
      border-radius: 8px;
      font-family: 'Cairo', sans-serif;
      font-size: 15px;
      font-weight: 600;
      cursor: pointer;
      transition: background 0.2s;
      text-decoration: none;
    }

    .btn-cancel:hover {
      background: var(--green-light);
      border-color: var(--green-btn);
    }

    /* ── Form elements ── */
    .form-group {
      margin-bottom: 16px;
    }

    .form-label {
      display: block;
      font-size: 13px;
      font-weight: 600;
      color: var(--text-mid);
      margin-bottom: 6px;
    }

    .form-label .required {
      color: var(--error);
      margin-right: 2px;
    }

    .form-input {
      width: 100%;
      padding: 12px 14px;
      border: 1.5px solid var(--border);
      border-radius: 8px;
      font-family: 'Cairo', sans-serif;
      font-size: 14px;
      color: var(--text-dark);
      background: var(--white);
      outline: none;
      transition: border-color 0.2s, box-shadow 0.2s;
      direction: rtl;
    }

    .form-input::placeholder {
      color: #BBBBBB;
      font-size: 13px;
    }

    .form-input:focus {
      border-color: var(--green-btn);
      box-shadow: 0 0 0 3px rgba(27, 67, 50, 0.10);
    }

    .form-input.is-invalid {
      border-color: var(--error);
    }

    .form-error {
      font-size: 12px;
      color: var(--error);
      margin-top: 4px;
    }

    textarea.form-input {
      resize: vertical;
      min-height: 90px;
    }

    /* ── File upload zone ── */
    .file-upload-zone {
      border: 2px dashed var(--border);
      border-radius: 10px;
      padding: 28px 16px;
      text-align: center;
      cursor: pointer;
      transition: border-color 0.2s, background 0.2s;
      background: #FAFAFA;
      position: relative;
    }

    .file-upload-zone:hover,
    .file-upload-zone.dragover {
      border-color: var(--green-btn);
      background: var(--green-light);
    }

    .file-upload-zone input[type="file"] {
      position: absolute;
      inset: 0;
      opacity: 0;
      cursor: pointer;
      width: 100%;
      height: 100%;
    }

    .file-upload-icon {
      font-size: 28px;
      margin-bottom: 8px;
      display: block;
    }

    .file-upload-text {
      font-size: 13px;
      color: var(--text-light);
      font-weight: 500;
    }

    .file-upload-hint {
      font-size: 11px;
      color: #AAAAAA;
      margin-top: 4px;
    }

    .file-selected-name {
      font-size: 13px;
      color: var(--green-btn);
      font-weight: 600;
      margin-top: 6px;
    }

    /* ── Audio player ── */
    .audio-player-box {
      background: transparent;
      padding: 0;
      margin-bottom: 24px;
      direction: ltr;
      /* Keeping player LTR for standard seek progression */
    }

    .audio-player-title {
      display: flex;
      align-items: center;
      justify-content: flex-end;
      /* Align to right for Arabic text */
      gap: 8px;
      margin-bottom: 14px;
      font-size: 14px;
      font-weight: 700;
      color: var(--green-btn);
      direction: rtl;
      /* Title is Arabic */
    }

    .audio-player-progress-container {
      margin-bottom: 24px;
    }

    .audio-player-progress {
      display: flex;
      align-items: center;
      margin-bottom: 8px;
    }

    .audio-slider {
      flex: 1;
      -webkit-appearance: none;
      appearance: none;
      height: 4px;
      border-radius: 2px;
      background: #E0E0E0;
      outline: none;
      cursor: pointer;
      background-image: linear-gradient(var(--green-btn), var(--green-btn));
      background-size: 0% 100%;
      background-repeat: no-repeat;
    }

    .audio-slider::-webkit-slider-thumb {
      -webkit-appearance: none;
      width: 22px;
      height: 22px;
      border-radius: 50%;
      background: var(--white);
      border: 1px solid #D0D0D0;
      cursor: pointer;
      box-shadow: 0 3px 8px rgba(0, 0, 0, 0.15);
    }

    .audio-time-row {
      display: flex;
      justify-content: space-between;
      margin-top: 6px;
      font-family: sans-serif;
    }

    .audio-time {
      font-size: 12px;
      color: var(--text-light);
      font-weight: 500;
    }

    .audio-controls {
      display: flex;
      align-items: center;
      justify-content: center;
      gap: 24px;
      margin-top: 20px;
    }

    .audio-ctrl-btn {
      background: none;
      border: none;
      color: var(--green-btn);
      display: flex;
      align-items: center;
      justify-content: center;
      cursor: pointer;
      padding: 8px;
      transition: transform 0.15s, opacity 0.2s;
    }

    .audio-ctrl-btn:hover {
      transform: scale(1.1);
      opacity: 0.8;
    }

    .audio-ctrl-btn svg {
      width: 24px;
      height: 24px;
      fill: currentColor;
    }

    .audio-play-btn {
      width: 82px;
      height: 82px;
      border-radius: 50%;
      background: var(--green-btn);
      color: var(--white);
      border: none;
      cursor: pointer;
      display: flex;
      align-items: center;
      justify-content: center;
      transition: transform 0.15s, box-shadow 0.2s;
      box-shadow: 0 6px 20px rgba(27, 67, 50, 0.25);
    }

    .audio-play-btn:hover {
      transform: scale(1.05);
      box-shadow: 0 8px 24px rgba(27, 67, 50, 0.35);
    }

    .audio-play-btn svg {
      width: 32px;
      height: 32px;
      fill: currentColor;
    }

    /* ── Search bar ── */
    .search-bar {
      position: relative;
      margin-bottom: 14px;
    }

    .search-bar input {
      width: 100%;
      padding: 10px 38px 10px 14px;
      border: 1.5px solid var(--border);
      border-radius: 8px;
      font-family: 'Cairo', sans-serif;
      font-size: 13px;
      color: var(--text-dark);
      background: var(--white);
      outline: none;
      direction: rtl;
      transition: border-color 0.2s;
    }

    .search-bar input:focus {
      border-color: var(--green-btn);
      box-shadow: 0 0 0 3px rgba(27, 67, 50, 0.08);
    }

    .search-bar .search-icon {
      position: absolute;
      right: 12px;
      top: 50%;
      transform: translateY(-50%);
      color: var(--text-light);
      font-size: 15px;
      pointer-events: none;
    }

    /* ── Nasheed list ── */
    .nasheed-list {
      display: flex;
      flex-direction: column;
      gap: 12px;
      padding: 10px 16px;
    }

    .nasheed-item {
      background: var(--white);
      border: 1px solid #EAEAEA;
      border-radius: 12px;
      padding: 16px;
      display: flex;
      flex-direction: column;
      gap: 14px;
      box-shadow: 0 2px 8px rgba(0, 0, 0, 0.04);
      transition: transform 0.2s, box-shadow 0.2s;
    }

    .bottom-actions {
      display: flex;
      align-items: center;
      justify-content: space-between;
    }

    .nasheed-item:hover {
      box-shadow: 0 4px 12px rgba(0, 0, 0, 0.08);
    }

    .nasheed-drag-handle {
      color: #BBB;
      cursor: grab;
      flex-shrink: 0;
      padding: 4px;
      display: flex;
      align-items: center;
      justify-content: center;
    }

    .nasheed-drag-handle svg {
      width: 20px;
      height: 20px;
      fill: currentColor;
    }

    .nasheed-info {
      flex: 1;
      min-width: 0;
      text-align: right;
    }

    .nasheed-name {
      font-size: 17px;
      font-weight: 800;
      color: var(--green-btn);
      margin-bottom: 4px;
      letter-spacing: -0.2px;
    }

    .nasheed-singer {
      font-size: 13px;
      font-weight: 600;
      color: var(--text-mid);
      margin-bottom: 10px;
      opacity: 0.8;
    }

    .nasheed-meta {
      display: flex;
      flex-wrap: wrap;
      gap: 12px;
    }

    .nasheed-meta-item {
      display: flex;
      align-items: center;
      gap: 6px;
      font-size: 11px;
      color: #666;
      background: #F2F5F3;
      padding: 5px 12px;
      border-radius: 8px;
      font-weight: 700;
      border: 1px solid #E8EBE9;
    }

    .nasheed-meta-item svg {
      width: 14px;
      height: 14px;
      fill: var(--green-btn);
      opacity: 0.7;
    }

    .nasheed-actions {
      display: flex;
      gap: 8px;
      flex-shrink: 0;
    }

    .btn-edit-small,
    .btn-delete-small {
      height: 38px;
      display: flex;
      align-items: center;
      justify-content: center;
      border-radius: 10px;
      border: none;
      cursor: pointer;
      transition: all 0.2s;
      color: #0D3B2E;
      text-decoration: none;
      font-size: 16px;
      padding: 10px;
      background: #F9F9F9;

      border: 1px solid #E8EBE9;
    }

    .btn-delete-small {
      color: var(--error);
    }

    .btn-edit-small:hover {
      background: #DBEAFE;
      transform: translateY(-2px);
    }

    .btn-delete-small:hover {
      background: #FFCDD2;
      transform: translateY(-2px);
    }

    .btn-edit-small svg,
    .btn-delete-small svg {
      width: 18px;
      height: 18px;
      fill: currentColor;
    }

    /* ── Empty state ── */
    .empty-state {
      text-align: center;
      padding: 48px 24px;
      color: var(--text-light);
    }

    .empty-state .empty-icon {
      font-size: 48px;
      margin-bottom: 12px;
      display: block;
    }

    .empty-state p {
      font-size: 14px;
    }

    /* ── Modal ── */
    .modal-overlay {
      display: none;
      position: fixed;
      inset: 0;
      background: rgba(0, 0, 0, 0.45);
      z-index: 1000;
      align-items: center;
      justify-content: center;
      padding: 24px;
    }

    .modal-overlay.active {
      display: flex;
    }

    .modal-box {
      background: var(--white);
      border-radius: 16px;
      padding: 28px 24px 24px;
      max-width: 320px;
      width: 100%;
      text-align: center;
      position: relative;
      box-shadow: 0 8px 40px rgba(0, 0, 0, 0.18);
      animation: modalIn 0.22s ease;
    }

    @keyframes modalIn {
      from {
        opacity: 0;
        transform: scale(0.92) translateY(12px);
      }

      to {
        opacity: 1;
        transform: scale(1) translateY(0);
      }
    }

    .modal-close {
      position: absolute;
      top: 12px;
      left: 14px;
      background: none;
      border: none;
      font-size: 20px;
      color: var(--text-light);
      cursor: pointer;
      line-height: 1;
    }

    .modal-title {
      font-size: 18px;
      font-weight: 800;
      color: var(--text-dark);
      margin-bottom: 8px;
    }

    .modal-subtitle {
      font-size: 13px;
      color: var(--text-mid);
      margin-bottom: 22px;
      line-height: 1.6;
    }

    .modal-btn-row {
      display: grid;
      grid-template-columns: 1fr 1fr;
      gap: 10px;
    }

    .modal-btn-confirm {
      padding: 11px;
      background: var(--error);
      color: var(--white);
      border: none;
      border-radius: 8px;
      font-size: 14px;
      font-weight: 700;
      cursor: pointer;
      transition: background 0.2s;
    }

    .modal-btn-confirm:hover {
      background: #B71C1C;
    }

    .modal-btn-cancel {
      padding: 11px;
      background: var(--white);
      color: var(--text-mid);
      border: 1.5px solid var(--border);
      border-radius: 8px;
      font-family: 'Cairo', sans-serif;
      font-size: 14px;
      font-weight: 600;
      cursor: pointer;
      transition: background 0.2s;
    }

    .modal-btn-cancel:hover {
      background: #F5F5F5;
    }

    /* ── Responsive ── */
    @media (max-width: 440px) {
      .admin-card {
        border-radius: 0;
      }
    }

    /* ── Side Drawer ── */
    .drawer-overlay {
      display: none;
      position: fixed;
      inset: 0;
      background: rgba(0, 0, 0, 0.40);
      z-index: 500;
    }

    .drawer-overlay.open {
      display: block;
    }

    .side-drawer {
      position: fixed;
      top: 0;
      right: -280px;
      width: 260px;
      height: 100%;
      background: var(--white);
      z-index: 600;
      box-shadow: -4px 0 24px rgba(0, 0, 0, 0.15);
      transition: right 0.28s cubic-bezier(0.4, 0, 0.2, 1);
      display: flex;
      flex-direction: column;
      overflow: hidden;
    }

    .side-drawer.open {
      right: 0;
    }

    .drawer-header {
      background: var(--green-dark);
      padding: 28px 20px 20px;
      display: flex;
      flex-direction: column;
      align-items: center;
      gap: 8px;
    }

    .drawer-header img,
    .drawer-header svg {
      width: 64px;
      height: auto;
    }

    .drawer-brand {
      font-size: 20px;
      font-weight: 800;
      color: var(--white);
      letter-spacing: 1px;
    }

    .drawer-nav {
      flex: 1;
      padding: 12px 0;
    }

    .drawer-nav-item {
      display: flex;
      align-items: center;
      gap: 12px;
      padding: 14px 20px;
      font-size: 15px;
      font-weight: 600;
      color: var(--text-dark);
      text-decoration: none;
      border-bottom: 1px solid #F0F0F0;
      transition: background 0.15s;
      cursor: pointer;
      background: none;
      border-left: none;
      border-right: none;
      border-top: none;
      width: 100%;
      text-align: right;
      font-family: 'Cairo', sans-serif;
    }

    .drawer-nav-item:first-child {
      border-top: 1px solid #F0F0F0;
    }

    .drawer-nav-item:hover {
      background: var(--green-light);
    }

    .drawer-nav-item .nav-icon {
      font-size: 18px;
    }

    .drawer-nav-item.danger {
      color: var(--error);
    }

    .drawer-nav-item.danger:hover {
      background: #FFF0F0;
    }
  </style>
</head>

<body>
  <!-- Drawer overlay -->
  <div class="drawer-overlay" id="drawer-overlay" onclick="closeDrawer()"></div>

  <!-- Side drawer -->
  <div class="side-drawer" id="side-drawer" role="navigation" aria-label="القائمة الجانبية">
    <div class="drawer-header">
      @php
        $drawerLogo = \App\Models\Setting::get('logo_path');
      @endphp
      @if($drawerLogo)
        <img src="{{ asset('storage/' . $drawerLogo) }}" alt="Tijan Logo"
          style="width: 64px; height: auto; border-radius: 8px;">
      @else
        <x-tijan-logo width="64" height="72" />
      @endif
      <span class="drawer-brand">Tijan</span>
    </div>
    <nav class="drawer-nav">
      <a href="{{ route('home') }}" class="drawer-nav-item">
        <span class="nav-icon">
          <svg viewBox="0 0 24 24" width="20" height="20" fill="currentColor">
            <path d="M12 3v10.55c-.59-.34-1.27-.55-2-.55-2.21 0-4 1.79-4 4s1.79 4 4 4 4-1.79 4-4V7h4V3h-6z" />
          </svg>
        </span>
        الأناشيد
      </a>
      <a href="{{ route('settings.index') }}" class="drawer-nav-item" id="drawer-settings-link">
        <span class="nav-icon">
          <svg viewBox="0 0 24 24" width="20" height="20" fill="currentColor">
            <path
              d="M19.14 12.94c.04-.3.06-.61.06-.94 0-.32-.02-.64-.07-.94l2.03-1.58c.18-.14.23-.41.12-.61l-1.92-3.32c-.12-.22-.37-.29-.59-.22l-2.39.96c-.5-.38-1.03-.7-1.62-.94l-.36-2.54c-.04-.24-.24-.41-.48-.41h-3.84c-.24 0-.43.17-.47.41l-.36 2.54c-.59.24-1.13.57-1.62.94l-2.39-.96c-.22-.08-.47 0-.59.22L2.74 8.87c-.12.21-.08.47.12.61l2.03 1.58c-.05.3-.09.63-.09.94s.02.64.07.94l-2.03 1.58c-.18.14-.23.41-.12.61l1.92 3.32c.12.22.37.29.59.22l2.39-.96c.5.38 1.03.7 1.62.94l.36 2.54c.05.24.24.41.48.41h3.84c.24 0 .44-.17.47-.41l.36-2.54c.59-.24 1.13-.56 1.62-.94l2.39.96c.22.08.47 0 .59-.22l1.92-3.32c.12-.22.07-.47-.12-.61l-2.01-1.58zM12 15.6c-1.98 0-3.6-1.62-3.6-3.6s1.62-3.6 3.6-3.6 3.6 1.62 3.6 3.6-1.62 3.6-3.6 3.6z" />
          </svg>
        </span>
        الأعدادات
      </a>
      <form method="POST" action="{{ route('logout') }}" style="margin:0;">
        @csrf
        <button type="submit" class="drawer-nav-item danger" id="drawer-logout-btn">
          <span class="nav-icon">
            <svg viewBox="0 0 24 24" width="20" height="20" fill="currentColor">
              <path
                d="M10.09 15.59L11.5 17l5-5-5-5-1.41 1.41L12.67 11H3v2h9.67l-2.58 2.59zM19 3H5c-1.11 0-2 .9-2 2v4h2V5h14v14H5v-4H3v4c0 1.1.89 2 2 2h14c1.1 0 2-.9 2-2V5c0-1.1-.9-2-2-2z" />
            </svg>
          </span>
          تسجيل الخروج
        </button>
      </form>
    </nav>
  </div>

  <div class="admin-wrapper">
    <div class="admin-card">
      <!-- Top bar -->
      <div class="admin-topbar">
        <button class="admin-topbar-menu" id="drawer-toggle-btn" onclick="openDrawer()" aria-label="القائمة">
          <svg viewBox="0 0 24 24" width="24" height="24" fill="currentColor">
            <path d="M3 18h18v-2H3v2zm0-5h18v-2H3v2zm0-7v2h18V6H3z" />
          </svg>
        </button>
        <span class="admin-topbar-title">لوحة التحكم</span>
      </div>

      {{ $slot }}
    </div>
  </div>

  <script>
    function openDrawer() {
      document.getElementById('side-drawer').classList.add('open');
      document.getElementById('drawer-overlay').classList.add('open');
      document.body.style.overflow = 'hidden';
    }
    function closeDrawer() {
      document.getElementById('side-drawer').classList.remove('open');
      document.getElementById('drawer-overlay').classList.remove('open');
      document.body.style.overflow = '';
    }
    // Close drawer on Escape key
    document.addEventListener('keydown', function (e) {
      if (e.key === 'Escape') closeDrawer();
    });
  </script>
</body>

</html>