<x-admin-layout>
  <x-slot name="title">تعديل النشيد</x-slot>

  {{-- Page heading --}}
  <div class="admin-page-heading">
    <a href="{{ route('nasheeds.index') }}" class="back-btn" aria-label="رجوع">›</a>
    <h1>تعديل النشيد</h1>
  </div>

  <div class="admin-content">

    @if($errors->any())
      <div class="flash-error">
        @foreach($errors->all() as $error)
          <div>• {{ $error }}</div>
        @endforeach
      </div>
    @endif

    <form method="POST" action="{{ route('nasheeds.update', $nasheed) }}" enctype="multipart/form-data"
      id="edit-nasheed-form">
      @csrf
      @method('PUT')

      {{-- Name --}}
      <div class="form-group">
        <label class="form-label" for="name">
          أسم النشيد <span class="required">*</span>
        </label>
        <input type="text" id="name" name="name" class="form-input {{ $errors->has('name') ? 'is-invalid' : '' }}"
          placeholder="أدخل أسم النشيد" value="{{ old('name', $nasheed->name) }}" required autocomplete="off">
        @error('name')
          <div class="form-error">{{ $message }}</div>
        @enderror
      </div>

      {{-- Singer --}}
      <div class="form-group">
        <label class="form-label" for="singer">
          أسم المنشد <span class="required">*</span>
        </label>
        <input type="text" id="singer" name="singer" class="form-input {{ $errors->has('singer') ? 'is-invalid' : '' }}"
          placeholder="أدخل أسم المنشد" value="{{ old('singer', $nasheed->singer) }}" required autocomplete="off">
        @error('singer')
          <div class="form-error">{{ $message }}</div>
        @enderror
      </div>

      {{-- Audio --}}
      <div class="form-group">
        <label class="form-label" for="audio">
          الملف الصوتي
          @if($nasheed->audio_path)
            <span style="font-size:11px; color:var(--green-btn); font-weight:500; margin-right:6px;">🎵 يوجد ملف
              مرفوع</span>
          @endif
        </label>

        {{-- Audio player if file exists --}}
        @if($nasheed->audio_path)
          <div class="audio-player-box" id="audio-player-box">
            <audio id="audio-element" src="{{ asset('storage/' . $nasheed->audio_path) }}" preload="metadata"></audio>

            <div class="audio-player-title">
              <span>{{ basename($nasheed->audio_path) }}</span>
              <svg viewBox="0 0 24 24" width="18" height="18" fill="currentColor">
                <path d="M12 3v10.55c-.59-.34-1.27-.55-2-.55-2.21 0-4 1.79-4 4s1.79 4 4 4 4-1.79 4-4V7h4V3h-6z" />
              </svg>
            </div>

            <div class="audio-player-progress-container">
              <div class="audio-player-progress">
                <input type="range" class="audio-slider" id="audio-seek" min="0" value="0" step="0.1">
              </div>
              <div class="audio-time-row">
                <span class="audio-time" id="current-time">0:00</span>
                <span class="audio-time" id="total-time">0:00</span>
              </div>
            </div>

            {{-- Controls --}}
            <div class="audio-controls">
              {{-- Previous track icon |< --}} <button type="button" class="audio-ctrl-btn" onclick="skipTo(0)"
                title="إلى البداية">
                <svg viewBox="0 0 24 24">
                  <path d="M6 6h2v12H6zm3.5 6l8.5 6V6z" />
                </svg>
                </button>

                {{-- Seek back << --}} <button type="button" class="audio-ctrl-btn" onclick="skipAudio(-5)"
                  title="5 ثوانٍ للخلف">
                  <svg viewBox="0 0 24 24">
                    <path d="M11 18V6l-8.5 6 8.5 6zm.5-6l8.5 6V6l-8.5 6z" />
                  </svg>
                  </button>

                  {{-- Play/Pause --}}
                  <button type="button" class="audio-play-btn" id="play-pause-btn" onclick="togglePlay()"
                    title="تشغيل / إيقاف">
                    <span id="play-icon">
                      <svg viewBox="0 0 24 24">
                        <path d="M8 5v14l11-7z" />
                      </svg>
                    </span>
                  </button>

                  {{-- Seek forward >> --}}
                  <button type="button" class="audio-ctrl-btn" onclick="skipAudio(5)" title="5 ثوانٍ للأمام">
                    <svg viewBox="0 0 24 24">
                      <path d="M13 6v12l8.5-6L13 6zM4 18l8.5-6L4 6v12z" />
                    </svg>
                  </button>

                  {{-- Next track icon >| --}}
                  <button type="button" class="audio-ctrl-btn" onclick="skipTo(audioEl.duration)" title="إلى النهاية">
                    <svg viewBox="0 0 24 24">
                      <path d="M6 18l8.5-6L6 6v12zM16 6h2v12h-2z" />
                    </svg>
                  </button>
            </div>
          </div>
        @endif

        {{-- Upload new file --}}
        <div class="file-upload-zone" id="audio-drop-zone" ondragover="handleDragOver(event)"
          ondragleave="handleDragLeave(event)" ondrop="handleDrop(event)"
          style="{{ $nasheed->audio_path ? 'margin-top:10px;' : '' }}">
          <input type="file" id="audio" name="audio" accept=".mp3,.wav,.ogg,.aac" onchange="handleFileSelect(this)">
          <span class="file-upload-icon">⬆️</span>
          <div class="file-upload-text">
            {{ $nasheed->audio_path ? 'استبدال الملف الصوتي' : 'رفع ملف صوتي' }}
          </div>
          <div class="file-upload-hint">(MP3, WAV)</div>
          <div class="file-selected-name" id="selected-file-name" style="display:none;"></div>
        </div>
        @error('audio')
          <div class="form-error">{{ $message }}</div>
        @enderror
      </div>

      {{-- Lyrics --}}
      <div class="form-group">
        <label class="form-label" for="lyrics">كلمات النشيد</label>
        <textarea id="lyrics" name="lyrics" class="form-input {{ $errors->has('lyrics') ? 'is-invalid' : '' }}"
          placeholder="أدخل كلمات النشيد" rows="6">{{ old('lyrics', $nasheed->lyrics) }}</textarea>
        @error('lyrics')
          <div class="form-error">{{ $message }}</div>
        @enderror
      </div>

      {{-- Submit --}}
      <div style="margin-top:24px;">
        <button type="submit" class="btn-primary full" id="btn-submit-edit" style="margin-bottom:12px;">حفظ</button>
        <a href="{{ route('nasheeds.index') }}" class="btn-cancel full" style="display:flex;"
          id="btn-cancel-edit">إلغاء</a>
      </div>
    </form>
  </div>

  <script>
    // ── File upload ──
    function handleFileSelect(input) {
      const nameEl = document.getElementById('selected-file-name');
      if (input.files && input.files[0]) {
        nameEl.textContent = '📎 ' + input.files[0].name;
        nameEl.style.display = 'block';
      } else {
        nameEl.style.display = 'none';
      }
    }

    function handleDragOver(e) {
      e.preventDefault();
      document.getElementById('audio-drop-zone').classList.add('dragover');
    }

    function handleDragLeave(e) {
      document.getElementById('audio-drop-zone').classList.remove('dragover');
    }

    function handleDrop(e) {
      e.preventDefault();
      document.getElementById('audio-drop-zone').classList.remove('dragover');
      const files = e.dataTransfer.files;
      if (files.length > 0) {
        const input = document.getElementById('audio');
        const dt = new DataTransfer();
        dt.items.add(files[0]);
        input.files = dt.files;
        handleFileSelect(input);
      }
    }

    // ── Audio player ──
    const audioEl = document.getElementById('audio-element');
    const playIcon = document.getElementById('play-icon');
    const currentTimeEl = document.getElementById('current-time');
    const totalTimeEl = document.getElementById('total-time');
    const seekSlider = document.getElementById('audio-seek');

    function formatTime(secs) {
      if (isNaN(secs)) return '0:00';
      const m = Math.floor(secs / 60);
      const s = Math.floor(secs % 60);
      return m + ':' + (s < 10 ? '0' : '') + s;
    }

    function updateSliderFill() {
      if (!seekSlider) return;
      const val = (seekSlider.value / seekSlider.max) * 100;
      seekSlider.style.backgroundSize = val + '% 100%';
    }

    if (audioEl) {
      audioEl.addEventListener('loadedmetadata', function () {
        seekSlider.max = audioEl.duration;
        totalTimeEl.textContent = formatTime(audioEl.duration);
        updateSliderFill();
      });

      audioEl.addEventListener('timeupdate', function () {
        seekSlider.value = audioEl.currentTime;
        currentTimeEl.textContent = formatTime(audioEl.currentTime);
        updateSliderFill();
      });

      audioEl.addEventListener('ended', function () {
        playIcon.innerHTML = `<svg viewBox="0 0 24 24"><path d="M8 5v14l11-7z"/></svg>`;
        updateSliderFill();
      });

      seekSlider && seekSlider.addEventListener('input', function () {
        audioEl.currentTime = this.value;
        updateSliderFill();
      });
    }

    function togglePlay() {
      if (!audioEl) return;
      if (audioEl.paused) {
        audioEl.play();
        playIcon.innerHTML = `<svg viewBox="0 0 24 24"><path d="M6 19h4V5H6v14zm8-14v14h4V5h-4z"/></svg>`;
      } else {
        audioEl.pause();
        playIcon.innerHTML = `<svg viewBox="0 0 24 24"><path d="M8 5v14l11-7z"/></svg>`;
      }
    }

    function skipAudio(seconds) {
      if (!audioEl) return;
      audioEl.currentTime = Math.max(0, Math.min(audioEl.duration, audioEl.currentTime + seconds));
    }

    function skipTo(pos) {
      if (!audioEl) return;
      audioEl.currentTime = pos;
    }
  </script>
</x-admin-layout>